// models/Banner.js
module.exports = (sequelize, DataTypes) => {
  const Banner = sequelize.define(
    "Banner",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      college_name: {
        type: DataTypes.STRING(250),
        allowNull: false,
      },
      userfile: {
        type: DataTypes.STRING(255),
        allowNull: true, // Must allow null
      },
      link: {
        type: DataTypes.STRING(255), // Changed to STRING because you use URL strings
        defaultValue: "link",
      },
    },
    {
      tableName: "tbl_banner",
      timestamps: false,
      underscored: false,
    }
  );
  return Banner;
};
