module.exports = (sequelize, DataTypes) => {
  const Course = sequelize.define(
    "Course",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      name: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      programType: {
        type: DataTypes.ENUM(
          "Bachelors",
          "Masters",
          "Doctorate",
          "Diploma",
          "Certification"
        ),
        field: "program_type",
      },
      studyMode: {
        type: DataTypes.ENUM("Full Time", "Part Time", "Online"),
        field: "study_mode",
      },
      duration: {
        type: DataTypes.STRING,
        allowNull: false,
      },
      feesIndian: {
        type: DataTypes.STRING,
        field: "fees_indian",
      },
      colleges: {
        type: DataTypes.STRING,
        field: "colleges",
      },
      overview: {
        type: DataTypes.TEXT,
      },
    },
    {
      tableName: "courses",
      timestamps: true,
      underscored: true,
    }
  );

  return Course;
};
