module.exports = (sequelize, DataTypes) => {
  const CollegeReview = sequelize.define(
    "tbl_college_reviews",
    {
      review_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: DataTypes.INTEGER,
      reviewer_name: DataTypes.STRING(500),
      rating: DataTypes.INTEGER,
      review_text: DataTypes.TEXT,
    },
    {
      tableName: "tbl_college_reviews",
      timestamps: false,
    }
  );

  CollegeReview.associate = (models) => {
    CollegeReview.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeReview;
};
