const express = require("express");
const router = express.Router();
const authController = require("../../controllers/AuthController/authController");
const { protect } = require("../../middleware/authMiddleware");

// Public routes
router.post("/register", authController.register);
router.post("/login", authController.login);
router.post("/forgot-password", authController.forgotPassword);
router.post("/reset-password/:token", authController.resetPassword);

// Protected route (requires valid JWT)
router.get("/me", protect, authController.getMe);

module.exports = router;
