const express = require("express");
const router = express.Router();
const notificationController = require("../controllers/notificationController");

// Create a new notification
router.post("/", notificationController.createNotification);

// Get all notifications (with optional category filter)
router.get("/", notificationController.getNotifications);

// Get single notification
router.get("/:id", notificationController.getNotificationById);

// Update notification
router.put("/:id", notificationController.updateNotification);

// Delete notification
router.delete("/:id", notificationController.deleteNotification);

module.exports = router;
