const express = require("express");
const router = express.Router();
const studentUGController = require("../../controllers/students/studentUGController");
const studentMBAController = require("../../controllers/students/studentMBAController");

// Route for UG students
router.post("/ug", studentUGController.createStudent);
router.get("/ug", studentUGController.getAllStudents);
router.get("/ug/:id", studentUGController.getStudentById);
router.put("/ug/:id", studentUGController.updateStudent);
router.delete("/ug/:id", studentUGController.deleteStudent);

// Route for MBA students
router.post("/mba/", studentMBAController.createStudent);
router.get("/mba/", studentMBAController.getAllStudents);
router.get("/mba/:id", studentMBAController.getStudentById);
router.put("/mba/:id", studentMBAController.updateStudent);
router.delete("/mba/:id", studentMBAController.deleteStudent);

module.exports = router;
