const express = require("express");
const router = express.Router();
const studentController = require("../../controllers/students/studentController");

// Student CRUD routes
router.post("/", studentController.createStudent);
router.get("/", studentController.getStudents);
router.get("/:id", studentController.getStudentById);
router.put("/:id", studentController.updateStudent);
router.delete("/:id", studentController.deleteStudent);

// Statistics route
router.get("/stats/count-by-category", studentController.getStudentStats);

module.exports = router;
